module net.BurtonRadons.spyl.expressionNegate;

private import net.BurtonRadons.spyl.expression;
private import net.BurtonRadons.spyl.expressionUnary;
private import net.BurtonRadons.spyl.value;
private import net.BurtonRadons.spyl.mark;
private import net.BurtonRadons.spyl.scope;

/** Negate a value; "-a". */
class NegateExpression : UnaryExpression
{
    /** Assign the parameters. */
    this (Mark mark, Expression a)
    {
        super (mark, a);
    }
    
    override Value evaluate (Scope scope)
    {
        return -a.evaluate (scope);
    }
    
    override char [] toString ()
    {
        return "-" ~ subString (a);
    }
    
    override int precedence ()
    {
        return Precedence.Unary;
    }
}
